(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8042,        325]*)
(*NotebookOutlinePosition[      8944,        355]*)
(*  CellTagsIndexPosition[      8900,        351]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\[Section]7.2 Examples", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The examples following are of the use of the function ",
  StyleBox["Transform",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Load the small Laplace transforms package."], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Remove[Transform, Isolate, LPTSolve, UnitPulse]\)], "Input"],

Cell[BoxData[
    \(<< Library/Mathematica/Applications/RossDE/LPT.m\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples: Solve DE using Transform"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Transform the differential equation."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], "+", \(3\ y[t]\)}],
           "==", "0"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\ LaplaceTransform[y[t], t, s] + s\ LaplaceTransform[y[t], t, s] - 
        y[0] == 0\)], "Output"]
}, Closed]],

Cell[TextData["Substitute the initial condition."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. y[0] \[Rule] 1\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-1\) + 3\ LaplaceTransform[y[t], t, s] + 
        s\ LaplaceTransform[y[t], t, s] == 0\)], "Output"]
}, Closed]],

Cell[TextData["Isolate LPT[y[t], t, s]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[%, LaplaceTransform[y[t], t, s]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{LaplaceTransform[y[t], t, s] \[Rule] 1\/\(3 + s\)}}\)], "Output"]
}, Closed]],

Cell[TextData["The solution can now be identified"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Transform the differential equation."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}], "+", \(y[t]\)}], "==",
           "0"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{\(LaplaceTransform[y[t], t, s]\), 
        "+", \(s\^2\ LaplaceTransform[y[t], t, s]\), "-", \(s\ y[0]\), "-", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "0", "]"}]}], "==", 
      "0"}]], "Output"]
}, Closed]],

Cell[TextData["Substitute the initial condition."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"%", "/.", 
      RowBox[{"{", 
        RowBox[{\(y[0] \[Rule] 0\), ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}], "\[Rule]", "1"}]}],
         "}"}]}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-1\) + LaplaceTransform[y[t], t, s] + 
        s\^2\ LaplaceTransform[y[t], t, s] == 0\)], "Output"]
}, Closed]],

Cell[TextData["Isolate LPT[y[t], t, s]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[%, LaplaceTransform[y[t], t, s]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{LaplaceTransform[y[t], t, s] \[Rule] 1\/\(1 + s\^2\)}}\)], "Output"]
}, Closed]],

Cell[TextData["The solution can now be identified"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples of Scaling: Transform[f[b t],t,s]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[Sin[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(b\/\(b\^2 + s\^2\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[Cos[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(s\/\(b\^2 + s\^2\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples of Transform[t f[t],t,s]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\ Sin[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(2\ b\ s\)\/\((b\^2 + s\^2)\)\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\ Cos[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(-b\^2\) + s\^2\)\/\((b\^2 + s\^2)\)\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\ Exp[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/\((\(-b\) + s)\)\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples of Transform[t^2 f[t],t,s]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\^2\ Sin[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-\(\(2\ b\ \((b\^2 - 
                3\ s\^2)\)\)\/\((b\^2 + s\^2)\)\^3\)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\^2\ Cos[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(2\ s\ \((\(-3\)\ b\^2 + s\^2)\)\)\/\((b\^2 + s\^2)\)\^3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transform[t\^2\ Exp[b\ t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\/\((\(-b\) + s)\)\^3\)], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{568, 597},
WindowMargins->{{20, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 90, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1869, 57, 190, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2084, 68, 119, 2, 56, "Section",
  Evaluatable->False],
Cell[2206, 72, 80, 1, 27, "Input"],
Cell[2289, 75, 81, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[2407, 81, 111, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2543, 87, 89, 2, 46, "Subsection",
  Evaluatable->False],
Cell[2635, 91, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2770, 97, 330, 9, 27, "Input"],
Cell[3103, 108, 120, 2, 43, "Output"]
}, Closed]],
Cell[3238, 113, 107, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3370, 119, 78, 2, 27, "Input"],
Cell[3451, 123, 122, 2, 43, "Output"]
}, Closed]],
Cell[3588, 128, 98, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3711, 134, 97, 2, 27, "Input"],
Cell[3811, 138, 87, 1, 42, "Output"]
}, Closed]],
Cell[3913, 142, 108, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4058, 149, 89, 2, 30, "Subsection",
  Evaluatable->False],
Cell[4150, 153, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4285, 159, 333, 9, 27, "Input"],
Cell[4621, 170, 299, 7, 45, "Output"]
}, Closed]],
Cell[4935, 180, 107, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5067, 186, 318, 9, 27, "Input"],
Cell[5388, 197, 122, 2, 45, "Output"]
}, Closed]],
Cell[5525, 202, 98, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5648, 208, 97, 2, 27, "Input"],
Cell[5748, 212, 90, 1, 42, "Output"]
}, Closed]],
Cell[5853, 216, 108, 2, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6010, 224, 119, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6154, 230, 85, 2, 27, "Input"],
Cell[6242, 234, 52, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6331, 240, 85, 2, 27, "Input"],
Cell[6419, 244, 52, 1, 40, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6520, 251, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6655, 257, 88, 2, 27, "Input"],
Cell[6746, 261, 67, 1, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6850, 267, 88, 2, 27, "Input"],
Cell[6941, 271, 76, 1, 48, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7054, 277, 88, 2, 27, "Input"],
Cell[7145, 281, 56, 1, 44, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7250, 288, 112, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7387, 294, 91, 2, 31, "Input"],
Cell[7481, 298, 112, 2, 48, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7630, 305, 91, 2, 31, "Input"],
Cell[7724, 309, 91, 1, 48, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7852, 315, 91, 2, 31, "Input"],
Cell[7946, 319, 56, 1, 44, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

se],

Cell[CellGroupData[{
Cell[6832, 252, 85, 2, 70, "Input"],
Cell[6920, 256, 100, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7057, 264, 85, 2, 70, "Input"],
Cell[7145, 268, 100, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7294, 277, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7429, 283, 88, 2, 70, "Input"],
Cell[7520, 287, 115, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7672, 295, 88, 2, 70, "Input"],
Cell[7763, 299, 136, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7936, 307, 88, 2, 70, "Input"],
Cell[8027, 311, 104, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8180, 320, 112, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8317, 326, 91, 2, 70, "Input"],
Cell[8411, 330, 158, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8606, 339, 91, 2, 70, "Input"],
Cell[8700, 343, 151, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8888, 352, 91, 2, 70, "Input"],
Cell[8982, 356, 104, 3, 70, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

